﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.GroupResource = {};

///Return the view of only resources of that Type and Site.
MCS.GroupResource.HandleOnChangeLookup = function () {
    var site = Xrm.Page.getAttribute("mcs_relatedsiteid").getValue();
    var type = Xrm.Page.getAttribute("mcs_type").getValue();
    if (type != null && site != null) {
        var ResourceControl = Xrm.Page.getControl("mcs_relatedresourceid");
        var ResourceViewID = site[0].id;
        var ResourceViewName = "Filtered by Site and Type";

        var UserControl = Xrm.Page.getControl("mcs_relateduserid");
        var UserViewID = "{47127E79-C3A2-E211-9B92-00155D144F0F}";
        var UserViewName = "Filtered By Type";

        var ResourceColumns = [
            'mcs_resourceid',
            'mcs_name',
            'createdon'
        ];
        var ResourceConditions = [
            '<condition attribute="statecode" operator="eq" value="0"/>',
            '<condition attribute="mcs_relatedsiteid" operator="eq" uiname="' + MCS.cvt_Common.formatXML(site[0].name) + '" uitype="mcs_site" value="' + site[0].id + '"/>'
        ];
        var ResourceOrder = [
            'mcs_name',
            false
        ];
        var ResourceXmlLayout = '<grid name="resultset" object="10006" jump="mcs_name" select="1" icon="0" preview="0"><row name="result" id="mcs_resourceid"><cell name="mcs_name" width="200" /><cell name="mcs_relatedsiteid" width="125" /><cell name="mcs_type" width="125" /></row></grid>';
        var UserColumns = [
            'fullname',
            'title',
            'address1_telephone1',
            'businessunitid',
            'cvt_type',
            'systemuserid'
        ];
        var UserOrder = [
            'fullname',
            false
        ];
        var UserConditions = [
            '<condition attribute="isdisabled" operator="eq" value="0"/>',
            '<condition attribute="accessmode" operator="ne" value="3"/>',
            '<condition attribute="cvt_type" operator="eq" value="917290001"/>'
        ];
        var UserXmlLayout = '<grid name="resultset" object="8" jump="fullname" select="1" icon="0" preview="0"><row name="result" id="systemuserid"><cell name="fullname" width="200" /><cell name="cvt_type" width="125" /><cell name="businessunitid" width="150" /><cell name="title" width="100" /><cell name="address1_telephone1" width="100" /></row></grid>';

        if (type == 917290000) //All Required
            ResourceViewName = 'Filtered by Site (All Required)';
        else {
            if (type == 100000000) //Telepresenter
                UserConditions[2] = '<condition attribute="cvt_type" operator="eq" value="917290000"/>';

            ResourceConditions[2] = '<condition attribute="mcs_type" operator="eq" value="' + type + '"/>';
        }

        var FetchBase = MCS.cvt_Common.CreateFetch('systemuser', UserColumns, UserConditions, UserOrder);
        UserControl.addCustomView(UserViewID, "systemuser", UserViewName, FetchBase, UserXmlLayout, true);

        FetchBase = MCS.cvt_Common.CreateFetch('mcs_resource', ResourceColumns, ResourceConditions, ResourceOrder);
        ResourceControl.addCustomView(ResourceViewID, "mcs_resource", ResourceViewName, FetchBase, ResourceXmlLayout, true);
    }
};

//Check Type; Sets Visibility and Requirements.
MCS.GroupResource.ShowDetails = function () {
    var siteFieldValue = Xrm.Page.getAttribute("mcs_relatedsiteid").getValue();
    var typeDisable = true;

    switch (Xrm.Page.getAttribute("mcs_type").getValue()) {
        case 251920001: //Room
        case 251920002: //Technology
        case 251920000: //VistA Clinic
            Xrm.Page.getControl("mcs_relatedresourceid").setVisible(true);
            Xrm.Page.getControl("mcs_relatedresourceid").setFocus();
            Xrm.Page.getAttribute("mcs_relatedresourceid").setRequiredLevel("required");

            Xrm.Page.getControl("mcs_relateduserid").setVisible(false);
            Xrm.Page.getAttribute("mcs_relateduserid").setValue(null);
            Xrm.Page.getAttribute("mcs_relateduserid").setRequiredLevel("none");
            break;
        case 100000000: //Telepresenter
        case 99999999: //Provider
            Xrm.Page.getControl("mcs_relateduserid").setVisible(true);
            Xrm.Page.getControl("mcs_relateduserid").setFocus();
            Xrm.Page.getAttribute("mcs_relateduserid").setRequiredLevel("required");

            Xrm.Page.getControl("mcs_relatedresourceid").setVisible(false);
            Xrm.Page.getAttribute("mcs_relatedresourceid").setValue(null);
            Xrm.Page.getAttribute("mcs_relatedresourceid").setRequiredLevel("none");
            break;
        case 917290000: //All Required
            Xrm.Page.getControl("mcs_relateduserid").setVisible(true);
            Xrm.Page.getAttribute("mcs_relateduserid").setRequiredLevel("none");
            Xrm.Page.getControl("mcs_relatedresourceid").setVisible(true);
            Xrm.Page.getAttribute("mcs_relatedresourceid").setRequiredLevel("none");

            if (Xrm.Page.getAttribute("mcs_relatedresourceid").getValue() != null) {                           
                Xrm.Page.getAttribute("mcs_relateduserid").setValue(null);
                Xrm.Page.getAttribute("mcs_relateduserid").setRequiredLevel("none");
                Xrm.Page.getControl("mcs_relateduserid").setVisible(false);
            }
            if (Xrm.Page.getAttribute("mcs_relateduserid").getValue() != null) {               
                Xrm.Page.getAttribute("mcs_relatedresourceid").setValue(null);
                Xrm.Page.getAttribute("mcs_relatedresourceid").setRequiredLevel("none");
                Xrm.Page.getControl("mcs_relatedresourceid").setVisible(false);
            }
            break;
        default:
            typeDisable = false;
            //Clears value of related Resource/User if no type is selected. 
            Xrm.Page.getControl("mcs_relateduserid").setVisible(true);
            Xrm.Page.getAttribute("mcs_relateduserid").setRequiredLevel("none");
            Xrm.Page.getAttribute("mcs_relateduserid").setValue(null);

            Xrm.Page.getControl("mcs_relatedresourceid").setVisible(true);
            Xrm.Page.getAttribute("mcs_relatedresourceid").setRequiredLevel("none");
            Xrm.Page.getAttribute("mcs_relatedresourceid").setValue(null);
            break;
    }
    Xrm.Page.getControl("mcs_type").setDisabled(typeDisable);
    Xrm.Page.getControl("mcs_relatedsiteid").setDisabled(siteFieldValue != null);
};

MCS.GroupResource.CreateName = function (executionObj) {
    var recordName = Xrm.Page.getAttribute("mcs_name").getValue();
    var builtName = "";

    if (Xrm.Page.getControl("mcs_relatedresourceid").getVisible() && Xrm.Page.getAttribute("mcs_relatedresourceid").getValue() != null)
        builtName = Xrm.Page.getAttribute("mcs_relatedresourceid").getValue()[0].name;

    if (Xrm.Page.getControl("mcs_relateduserid").getVisible() && Xrm.Page.getAttribute("mcs_relateduserid").getValue() != null)
        builtName = Xrm.Page.getAttribute("mcs_relateduserid").getValue()[0].name;

    if (builtName == "") {
        alert("Please pick the related resource or user before saving.");
        executionObj.getEventArgs().preventDefault();
        return;
    }

    if (recordName != builtName) {
        Xrm.Page.getAttribute("mcs_name").setSubmitMode("always");
        Xrm.Page.getAttribute("mcs_name").setValue(builtName);
    }
};